
COMMENT This syntax is keyed to the data set Panel C Table 14 3
surgical and or obstetrical complications, this syntax is copyright by
Robert B Smith, 2011.


FILTER OFF.
USE ALL.
EXECUTE .

HILOGLINEAR
  miamihsp(0 1) precert(0 1)  comps(0 1) /CWEIGHT=count /METHOD=BACKWARD
  /CRITERIA MAXSTEPS(10) P(.05) ITERATION(20) DELTA(.5)
  /PRINT=FREQ RESID ASSOCIATION ESTIM
  /DESIGN .


COMMENT: This syntax produces logistic regression estimates.
WEIGHT
  BY count .

FILTER OFF.
USE ALL.
EXECUTE .


GENLOG
  comps  BY precert miamihsp
  /MODEL = MULTINOMIAL
  /PRINT = FREQ RESID ADJRESID ZRESID DEV ESTIM CORR COV
  /PLOT = RESID( ADJRESID ) NORMPROB( ADJRESID )
  /CRITERIA = CIN(95) ITERATE(20) CONVERGE(.001) DELTA(.5)
  /DESIGN  comps*miamihsp comps*precert  .

COMMENT The SAS syntax also estimates parameters for this table.